﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.IO;

namespace IPBL
{
    public static class Morphology
    {

        #region Binary Convertion
        static public Bitmap gray(string filename)
        {
            Bitmap bmp = new Bitmap(filename);
            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(width, height);

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c = bmp.GetPixel(i, j);
                    int tmp = (c.R + c.G + c.B) / 3;
                    bmpnew.SetPixel(i, j, Color.FromArgb(tmp, tmp, tmp));
                }
            }
            return bmpnew;
        }
        static public Bitmap gray_(Bitmap bmp)
        {
            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(width, height);

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c = bmp.GetPixel(i, j);
                    int tmp = (c.R + c.G + c.B) / 3;
                    bmpnew.SetPixel(i, j, Color.FromArgb(tmp, tmp, tmp));
                }
            }
            return bmpnew;
        }
        public static Bitmap binary(Bitmap bmp, int Threshold)
        {
            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(width, height);

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c = bmp.GetPixel(i, j);
                    bmpnew.SetPixel(i, j, c.R > Threshold ? Color.White : Color.Black);
                }
            }
            return bmpnew;
        }
        public static Bitmap binary_(Bitmap bmp)
        {
            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(width, height);

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c = bmp.GetPixel(i, j);
                    bmpnew.SetPixel(i, j, c.R > 127 ? Color.White : Color.Black);
                }
            }
            return bmpnew;
        }
        public static Bitmap binaryUP(Bitmap bmp)
        {
            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(width, height);
            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c = bmp.GetPixel(i, j);
                    bmpnew.SetPixel(i, j, (c.R >= 127 || c.G >= 127 || c.B >= 127) ? Color.White : Color.Black);
                }
            }
            return bmpnew;
        }
        public static Bitmap binaryLOW(Bitmap bmp)
        {
            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(width, height);
            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c = bmp.GetPixel(i, j);
                    bmpnew.SetPixel(i, j, (c.R == 0 || c.G == 0 || c.B == 0) ? Color.Black : Color.White);
                }
            }
            return bmpnew;
        }
        public static int morph_numCounts = 0;
        #endregion

        #region Basic Morphologic Operations
        public static Bitmap And(ref Bitmap bmp1, ref Bitmap bmp2)
        {
            if (bmp1.Width > bmp2.Width || bmp1.Height > bmp2.Height) return null;

            int[,] mat1 = Matris.Load.Matris2DFromeBMP(ref bmp1);
            int[,] mat2 = Matris.Load.Matris2DFromeBMP(ref bmp2);
            int[,] rez = new int[bmp1.Width, bmp1.Height];
            Matris.Logic.AND(ref mat1, ref mat2, ref rez, bmp1.Width, bmp2.Width);

            Bitmap bmp = Matris.Load.BMPfromeMatris2D(ref rez, bmp1.Width, bmp1.Height);

            return bmp;
        }
        /// <summary>
        /// یکی از عملگرهای موفولوژیکی کاهش،افزایش،پرکردن را انجام میدهد
        /// </summary>
        /// <param name="BaseColor">رنگ پایه</param>
        /// <param name="operand">dec ,inc ,fill</param>
        static public Bitmap morph(Bitmap bmp, string operand, int[,]structure, int sw, int sh)
        {
            bmp = Morphology.binary_(bmp);

            int[,] imagematris = Matris.Load.Matris2DFromeBMP(ref bmp);

            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(width, height);


            int SstartI = (sw - 1) / 2;
            int SstartJ = (sh - 1) / 2;



            switch (operand)
            {
                case "dec":
                    {
                        for (int i = SstartI; i < width - SstartI; i++)
                        {
                            for (int j = SstartJ; j < height - SstartJ; j++)
                            {
                                bool matches = false;
                                for (int a = -SstartI; a <= SstartI; a++)
                                {
                                    for (int b = -SstartJ; b <= SstartJ; b++)
                                    {
                                        if (structure[a + SstartI, b + SstartJ] == 1)
                                        {
                                            matches = true;
                                            if (imagematris[i + a, j + b] != 1)
                                            {
                                                matches = false;
                                                //exitting
                                                a = SstartI + 2;
                                                break;
                                            }
                                        }
                                    }
                                }
                                if (matches == true)
                                    bmpnew.SetPixel(i, j, Color.White);
                                else
                                    bmpnew.SetPixel(i, j, Color.Black);
                            }//j
                        }//i
                        break;
                    }
                case "inc":
                    {
                        for (int i = SstartI; i < width - SstartI; i++)
                        {
                            for (int j = SstartJ; j < height - SstartJ; j++)
                            {
                                bool matches = false;
                                for (int a = -SstartI; a <= SstartI; a++)
                                {
                                    for (int b = -SstartJ; b <= SstartJ; b++)
                                    {
                                        if (imagematris[i + a, j + b] == 1 && structure[a + SstartI, b + SstartJ] == 1)
                                        {
                                            matches = true;
                                            //exitting
                                            a = SstartI + 2;
                                            break;
                                        }
                                    }
                                }
                                if (matches == true)
                                    bmpnew.SetPixel(i, j, Color.White);
                                else
                                    bmpnew.SetPixel(i, j, Color.Black);
                            }
                        }
                        break;
                    }
            }//switch operand

            morph_numCounts++;

            return bmpnew;
        }
        static public void morph(ref int[,]imagematris, ref int [,]newimagematris,int width,int  height, string operand, ref int[,] structure, int sw, int sh)
        {
            int SstartI = (sw - 1) / 2;
            int SstartJ = (sh - 1) / 2;

            switch (operand)
            {
                case "dec":
                    {
                        for (int i = SstartI; i < width - SstartI; i++)
                        {
                            for (int j = SstartJ; j < height - SstartJ; j++)
                            {
                                bool matches = false;
                                for (int a = -SstartI; a <= SstartI; a++)
                                {
                                    for (int b = -SstartJ; b <= SstartJ; b++)
                                    {
                                        if (structure[a + SstartI, b + SstartJ] == 1)
                                        {
                                            matches = true;
                                            if (imagematris[i + a, j + b] != 1)
                                            {
                                                matches = false;
                                                //exitting
                                                a = SstartI + 2;
                                                break;
                                            }
                                        }
                                    }
                                }
                                if (matches == true)
                                    newimagematris[i, j] = 1;
                                else
                                    newimagematris[i, j] = 0;
                            }//j
                        }//i
                        break;
                    }
                case "inc":
                    {
                        for (int i = SstartI; i < width - SstartI; i++)
                        {
                            for (int j = SstartJ; j < height - SstartJ; j++)
                            {
                                    bool matches = false;
                                    for (int a = -SstartI; a <= SstartI; a++)
                                    {
                                        for (int b = -SstartJ; b <= SstartJ; b++)
                                        {
                                            if (imagematris[i + a, j + b] == 1 && structure[a + SstartI, b + SstartJ] == 1)
                                            {
                                                matches = true;
                                                //exitting
                                                a = SstartI + 2;
                                                break;
                                            }
                                        }
                                    }
                                    if (matches == true)
                                        newimagematris[i, j] = 1;
                                    else
                                        newimagematris[i, j] = 0;
                            }
                        }
                        break;
                    }
            }//switch operand

        }
        /// <summary>
        /// عملگر موفولوژیکی بستن، معادل یک افزایش و یک کاهش متوالی.
        /// خطوط نویز را نمایان تر میکند
        /// </summary>
        public static Bitmap close(string filename)
        {
            return morph(
                        morph(new Bitmap(filename), "inc", new int[,] { { 1, 1, 1 }, { 1, 1, 1 }, { 1, 1, 1 } }, 3, 3),
                        "dec", new int[,] { { 1, 1, 1 }, { 1, 1, 1 }, { 1, 1, 1 } }, 3, 3
                        );
        }
        public static Bitmap close(ref Bitmap image)
        {
            return morph(
                        morph(image, "inc", new int[,] { { 1, 1, 1 }, { 1, 1, 1 }, { 1, 1, 1 } }, 3, 3),
                        "dec", new int[,] { { 1, 1, 1 }, { 1, 1, 1 }, { 1, 1, 1 } }, 3, 3
                        );
        }
        public static Bitmap close(ref Bitmap image, int[,] mstruct, int mw, int mh)
        {
            return morph(morph(image, "inc", mstruct, mw, mh), "dec", mstruct, mw, mh);
        }
        /// <summary>
        /// عملگر مورفولوژیکی بازکردن، معادل یک کاهش و افزایش متوالی.
        /// خطوط نویز را مخفی تر میکند.
        /// </summary>
        public static Bitmap open(string filename)
        {
            return morph(
                        morph(new Bitmap(filename), "dec", new int[,] { { 1, 1, 1 }, { 1, 1, 1 }, { 1, 1, 1 } }, 3, 3),
                        "inc", new int[,] { { 1, 1, 1 }, { 1, 1, 1 }, { 1, 1, 1 } }, 3, 3
                        );
        }
        public static Bitmap open(ref Bitmap image)
        {
            return morph(
                        morph(image, "dec", new int[,] { { 1, 1, 1 }, { 1, 1, 1 }, { 1, 1, 1 } }, 3, 3),
                        "inc", new int[,] { { 1, 1, 1 }, { 1, 1, 1 }, { 1, 1, 1 } }, 3, 3
                        );
        }
        public static Bitmap open(ref Bitmap image, int[,] mstruct, int mw, int mh)
        {
            return morph(morph(image, "dec", mstruct, mw, mh), "inc", mstruct, mw, mh);
        }
        /// <summary>
        /// یک الگو را در  تصویر باینری جست و جو میکند،
        /// و در صورتیکه همه عناصر الگو با پیکسلهای زیر آن در تصویر باینری مطابقت داشته باشد
        ///  تصویر خروجی در آن محل را 1 میکند
        /// </summary>
        /// <param name="structore">عنصر ساختمانی بصورت ماتریس 1و 0</param>
        /// <param name="sw">طول عنصر ساختمانی</param>
        /// <param name="sh">ارتفاع عنصر ساختمانی</param>
        public static int[,] ERODE(ref int[,]input, int iw, int ih, int[,] structore, int sw, int sh)
        {
            int istart = (sw - 1) / 2, iend = iw - istart;
            int jstart = (sh - 1) / 2, jend = ih - jstart;

            int[,] bmpnew = new int[iw, ih];

            for (int i = istart; i < iend; i++)
            {
                for (int j = jstart; j < jend; j++)
                {
                    bool matched1 = true;
                    for (int ii = -istart; ii <= istart; ii++)
                    {
                        for (int jj = -jstart; jj <=jstart; jj++)
                        {
                            if ((structore[ii + istart, jj + jstart] == 1 && input[i + ii, j + jj] != 1) ||
                                (structore[ii + istart, jj + jstart] == 0 && input[i + ii, j + jj] != 0))
                                matched1 = false;
                        }//sl
                    }//sw
                    if (matched1 == true)
                        bmpnew[i, j] = 1;
                    else
                        bmpnew[i, j] = 0;
                }//j
            }//i

            find_numcounts++;

            return bmpnew;
        }
        /// <summary>
        ///در هر مرحله، عمل جست و جو را روی نتیجه مرحله قبل انجام میدهد، تاجاییکه تغییری ایجاد نشود.مرحله اول، همان تصویر اصلی است.
        /// </summary>
        public static int[,] SequentialERODE(ref int[,]input, int iw, int ih, int[,] structore, int sw, int sh)
        {
            int istart = (sw - 1) / 2, iend = iw - istart;
            int jstart = (sh - 1) / 2, jend = ih - jstart;

            int[,] bmpnew = new int[iw, ih];

            bool changeOccured = true;
            while (changeOccured == true)
            {
                try
                {
                    changeOccured = false;
                    for (int i = istart; i < iend; i++)
                    {
                        for (int j = jstart; j < jend; j++)
                        {
                            bool matched1 = true;
                            for (int ii = 0; ii < sw; ii++)
                            {
                                for (int jj = 0; jj < sh; jj++)
                                {
                                    int iof = ii - istart, jof = jj - jstart;/*
                                    if (!(input[i + iof, j + jof] == structore[ii, jj]))
                                        matched1 = false;*/
                                    if( (input[i + iof, j + jof] ==1&&structore[ii, jj]!=1)||
                                        (input[i + iof, j + jof] == 0 && structore[ii, jj] != 0))
                                        matched1 = false;
                                }//sl
                            }//sw
                            if (matched1 == true)
                            {
                                bmpnew[i, j] = 1;
                                changeOccured = true;
                            }
                            else
                                bmpnew[i, j] = 0;
                        }//j
                    }//i
                    bmpnew = new int[iw, ih];
                }

                catch{ return bmpnew; }
            }//while changes occures

            find_numcounts++;

            return bmpnew;
        }
        /// <summary>
        /// یک الگو را در  تصویر باینری جست و جو میکند،
        /// و در صورتیکه حد اقل یکی از عناصر الگو با پیکسلهای زیر آن در تصویر باینری
        /// مطابقت داشته باشد تصویر خروجی در آن محل را 1 میکند
        /// </summary>
        /// <param name="structore">عنصر ساختمانی بصورت ماتریس 1و 0</param>
        /// <param name="sw">طول عنصر ساختمانی</param>
        /// <param name="sh">ارتفاع عنصر ساختمانی</param>
        public static int[,] DILATE(ref int[,]input, int iw, int ih, int[,] structore, int sw, int sh)
        {
            int istart = (sw - 1) / 2, iend = iw - istart;
            int jstart = (sh - 1) / 2, jend = ih - jstart;

            int[,] bmpnew = new int[iw, ih];

            for (int i = istart; i < iend; i++)
            {
                for (int j = jstart; j < jend; j++)
                {
                    bmpnew[i - istart, j - jstart] = 0;
                    for (int ii = 0; ii < sw; ii++)
                    {
                        for (int jj = 0; jj < sh; jj++)
                        {
                            int iof = ii - istart, jof = jj - jstart;
                            if (structore[ii, jj] == 1)
                            {
                                if (input[i + iof, j + jof] == structore[ii, jj])
                                {
                                    bmpnew[i, j] = 1;
                                    ii = sw;
                                    break;
                                }
                            }
                        }//sl
                    }//sw
                }//j
            }//i

            find_numcounts++;

            return bmpnew;
        }
        public static int find_numcounts = 0;
        /// <summary>
        /// یک عنصر ساختمانی را در یک تصویر باینری جست و جو میکند
        /// </summary>
        /// <param name="findType">and, or, dec, hitmiss
        ///     .نوع آخر فقط جاهایی را نشان میدههد که فقط با الگوی داده شده مطابقت داشته اند
        /// </param>
        public static Bitmap find(ref Bitmap image, int[,] structore, int sw, int sh, string findType)
        {
            //tmps
            int[,] bmp1 = null;
            int[,] bmp2 = null;
            //rezult
            int w = image.Width, h = image.Height;
            int[,] f = Matris.Load.Matris2DFromeBMP(ref image);

            switch (findType)
            {
                case "and":
                    f = ERODE(ref f, w, h, structore, sw, sh);
                    break;
                case "or":
                    f = DILATE(ref f, w, h, structore, sw, sh);
                    break;
                case "dec":
                    f = SequentialERODE(ref f, w, h, structore, sw, sh);
                    break;
                case "hitmiss":
                    bmp1 = ERODE(ref f, w, h, structore, sw, sh);
                    int[,] notf = Matris.Logic.NOT(ref f, w, h);
                    bmp2 = ERODE(ref notf, w, h, Matris.Logic.NOT(ref structore, sw, sh), sw, sh);
                    Matris.Logic.AND(ref bmp1, ref bmp2, ref f, w, h);
                    break;
                case "hitmissOR":
                    bmp1 = DILATE(ref f, w, h, structore, sw, sh);
                    notf = Matris.Logic.NOT(ref f, w, h);
                    bmp2 = DILATE(ref notf, w, h, Matris.Logic.NOT(ref structore, sw, sh), sw, sh);
                    Matris.Logic.AND(ref bmp1, ref bmp2, ref f, w, h);
                    break;
                case "miss":
                    notf = Matris.Logic.NOT(ref f, w, h);
                    f = ERODE(ref notf, w, h, Matris.Logic.NOT(ref structore, sw, sh), sw, sh);
                    break;
            }
            find_numcounts++;

            return Matris.Load.BMPfromeMatris2D(ref f, w, h);
        }
        public static Bitmap find(string filename, int[,] structore, int sw, int sh, string findType)
        {
            Bitmap image = new Bitmap(filename);
            return find(ref image, structore, sw, sh, findType);
        }
        public static Bitmap hitmiss(Bitmap image, int[,] struct1, int w1, int h1, int[,] struct2, int w2, int h2)
        {
            int[,] finalimage = hitmiss(Matris.Load.Matris2DFromeBMP(ref image), image.Width, image.Height, struct1, w1, h1, struct2, w2, h2);
            return Matris.Load.BMPfromeMatris2D(ref finalimage, image.Width, image.Height);
        }
        public static int[,] hitmiss(int[,] image, int Width, int Height, int[,] struct1, int w1, int h1, int[,] struct2, int w2, int h2)
        {
            int[,] bmp1 = ERODE(ref image, Width, Height, struct1, w1, h1);
            image = Matris.Logic.NOT(ref image, Width, Height);
            int[,] bmp2 = ERODE(ref image, Width, Height, struct2, w2, h2);
            Matris.Logic.AND(ref bmp1, ref bmp2, ref image, Width, Height);
            return image;
        }
        #endregion

        #region Some  Other Morphologic Operations
        public static Bitmap Thin(ref Bitmap image)
        {
            int[,] imagematris = Matris.Load.Matris2DFromeBMP(ref image);
            int width = image.Width, height = image.Height;
            Thin(ref imagematris, width, height);
            return Matris.Load.BMPfromeMatris2D(ref imagematris, width, height);
        }
        public static Bitmap Thin_(ref Bitmap image)
        {
            int[,] imagematris = Matris.Load.Matris2DFromeBMP(ref image);
            int width = image.Width, height = image.Height;
            Thin(ref imagematris, width, height);
            return Matris.Load.BMPfromeMatris2D(ref imagematris, width, height);
        }
        public static void Thin(ref int[,] imagematris,int width,int height)
        {
            //dr
            int[,] lut1 = new int[,] { { 0, 0, 2 }, { 0, 1, 1 }, { 2, 1, 1 } };
            //tr
            int[,] lut2 = new int[,] { { 2, 0, 0 }, { 1, 1, 0 }, { 1, 1, 2 } };
            //tl
            int[,] lut3 = new int[,] { { 1, 1, 2 }, { 1, 1, 0 }, { 2, 0, 0 } };
            //dl
            int[,] lut4 = new int[,] { { 2, 1, 1 }, { 0, 1, 1 }, { 0, 0, 2 } };
            //l
            int[,] lut5 = new int[,] { { 1, 1, 1 }, { 2, 1, 2 }, { 0, 0, 0 } };
            //r
            int[,] lut6 = new int[,] { { 0, 0, 0 }, { 2, 1, 2 }, { 1, 1, 1 } };
            //d
            int[,] lut7 = new int[,] { { 0, 2, 1 }, { 0, 1, 1 }, { 0, 2, 1 } };
            //t
            int[,] lut8 = new int[,] { { 1, 2, 0 }, { 1, 1, 0 }, { 1, 2, 0 } };

            imagematris = Matris.Math.Sub(imagematris, hitmiss(imagematris, width, height, lut1, 3, 3, Matris.Logic.NOT(ref lut1, 3, 3), 3, 3), width, height);
            imagematris = Matris.Math.Sub(imagematris, hitmiss(imagematris, width, height, lut2, 3, 3, Matris.Logic.NOT(ref lut2, 3, 3), 3, 3), width, height);
            imagematris = Matris.Math.Sub(imagematris, hitmiss(imagematris, width, height, lut3, 3, 3, Matris.Logic.NOT(ref lut3, 3, 3), 3, 3), width, height);
            imagematris = Matris.Math.Sub(imagematris, hitmiss(imagematris, width, height, lut4, 3, 3, Matris.Logic.NOT(ref lut4, 3, 3), 3, 3), width, height);
            imagematris = Matris.Math.Sub(imagematris, hitmiss(imagematris, width, height, lut5, 3, 3, Matris.Logic.NOT(ref lut5, 3, 3), 3, 3), width, height);
            imagematris = Matris.Math.Sub(imagematris, hitmiss(imagematris, width, height, lut6, 3, 3, Matris.Logic.NOT(ref lut6, 3, 3), 3, 3), width, height);
            imagematris = Matris.Math.Sub(imagematris, hitmiss(imagematris, width, height, lut7, 3, 3, Matris.Logic.NOT(ref lut7, 3, 3), 3, 3), width, height);
            imagematris = Matris.Math.Sub(imagematris, hitmiss(imagematris, width, height, lut8, 3, 3, Matris.Logic.NOT(ref lut8, 3, 3), 3, 3), width, height);
        }
        public static int ThinSequantialy_Count = 0;
        public static Bitmap Thin_Sequentialy(ref Bitmap image)
        {
            int[,] imagematris = Matris.Load.Matris2DFromeBMP(ref image);
            int width = image.Width, height = image.Height;
            int[,] tmp = new int[width, height];
            Matris.Edit.copy(ref tmp, ref imagematris, width, height);

            ThinSequantialy_Count = 0;
            while (true)
            {
                ThinSequantialy_Count++;
                Thin(ref imagematris, width, height);
                if (Matris.Logic.AreEqual(ref imagematris, ref tmp, width, height)) break;
                Matris.Edit.copy(ref tmp, ref imagematris, width, height);
            }

            return Matris.Load.BMPfromeMatris2D(ref imagematris, width, height);
        }
        private static int skeletonise_Zero2OneChanges(int[] hoods ,int size)     
        {
            int count = 0;
            for (int i = 0; i < size - 1; i++) if (hoods[i] == 1 && hoods[i + 1] == 0) count++;
            if (hoods[size - 1] == 1 && hoods[0] == 0) count++;
            return count;
        }
        public static Bitmap skeletonise(ref Bitmap BMPimage)
        {
            int width = BMPimage.Width, height = BMPimage.Height;
            int[,] imagematris = Matris.Load.Matris2DFromeBMP(ref BMPimage);
            int [,]answermatris = new int[width,height];

            bool imageCHanged = true;
            while (imageCHanged)
            {
                imageCHanged = false;

                //remove pixels
                for (int i = 2; i < width - 1; i++)
                {
                    for (int j = 2; j < height - 1; j++)
                    {
                        if (imagematris[i, j] == 1)
                        {
                            //تعداد پیکسل های یک اطراف مرکز
                            int[] hoods = Matris.Load.NHOODS_2D(ref imagematris, 3, i, j);
                            int B = -1; for (int k = 0; k < 9; k++) if (hoods[k] == 1) B++;
                            int Condition1 = B > 1 && B < 7 ? 1 : 0;
                            //تعداد گذرهای از یک به صفر
                            int Condition2 = skeletonise_Zero2OneChanges(Matris.Load.NHOODS_2D(ref imagematris, 3, i, j), 9) == 1 ? 1 : 0;
                            //int Condition3 = skeletonise_Zero2OneChanges(Matris.Load.NHOODS_2D(ref imagematris, 3, i, j - 1), 9) != 1 ? 1 : 0;
                            int Condition3 = hoods[1] * hoods[5] * hoods[7] == 0 ? 1 : 0;
                            //int Condition4 = skeletonise_Zero2OneChanges(Matris.Load.NHOODS_2D(ref imagematris, 3, i + 1, j), 9) != 1 ? 1 : 0;
                            int Condition4 = hoods[5] * hoods[7] * hoods[3] == 0 ? 1 : 0;
                            //making dessision to remove pixels
                            if (Condition1 * Condition2 ==1)//* Condition3 * Condition4 == 1)
                            {
                                answermatris[i, j] = 0;
                                //imagematris[i, j] = 0;
                                imageCHanged = true;
                            }
                            else
                                answermatris[i, j] = 1;
                                //imagematris[i, j] = 1;
                        }//if white pixel
                    }//j
                }//i

                for (int i = 0; i < width; i++) for (int j = 0; j < height; j++) imagematris[i, j] = answermatris[i, j];

            }//while

            return Matris.Load.BMPfromeMatris2D(ref imagematris, width, height);
        }//skelet
        
        public static int Replaced_numcounts = 0;
        public static Bitmap replace(ref Bitmap image, int[,] StructureA, int swA, int shA, int[,] StructureB, int swB, int shB)
        {
            int[,] imagematris = Matris.Load.Matris2DFromeBMP(ref image);
            int width = image.Width, height = image.Height;

            int startIa = (swA - 1) / 2, startJa = (shA - 1) / 2;
            int startIb = (swB - 1) / 2, startJb = (shB - 1) / 2;

            int[,] newImageMatris = new int[width + startIb, height + startJb];
            int[,] changedPlaces = new int[width + startIb, height + startJb];

            for (int i = startIa; i < width - startIa; i++)
            {
                for (int j = startJa; j < height - startJa; j++)
                {
                    
                    //کلک مرتضوی
                    //این مقایسه انجام میشود تا تغییرات در یکدیگر تداخل ایجاد نکنند
                    bool hereIsChangedBefore = false;
                    for (int a = -startIa; a <= startIa; a++)
                        for (int b = -startJa; b <= startJa; b++)
                            if (changedPlaces[i + a, j + b] == 1)
                            {
                                hereIsChangedBefore = true;
                                a = startIa + 1;
                                break;
                            }
                    if (hereIsChangedBefore)
                        continue;


                    //check if here is StructureA
                    bool isStructureA = true;
                    //reading window
                    for (int a = -startIa; a <= startIa; a++)
                    {
                        for (int b = -startJa; b <= startJa; b++)
                        {
                            if (imagematris[i + a, j + b] != StructureA[a + startIa, b + startJa])
                            {
                                isStructureA = false;
                                //exiting
                                a = startIa + 1;
                                break;
                            }
                        }//b
                    }//a
                    
                    //if matched, then copy sB instead of sA
                    if (isStructureA == true)
                    {
                        for (int a = -startIb; a <= startIb; a++)
                        {
                            for (int b = -startJb; b <= startJb; b++)
                            {
                                newImageMatris[i + a, j + b] = StructureB[a + startIb, b + startJb];
                                changedPlaces[i + a, j + b] = 1;
                            }
                        }

                        //just for chekking in debugtime
                        //SaveMatrisToBMPFile(newImageMatris, width + startIb, height + startJb, "aaa.bmp");
                        //SaveMatrisToBMPFile(changedPlaces, width + startIb, height + startJb, "aaa.bmp");
                    }//if true

                }//j
            }//i

            Replaced_numcounts++;

            return Matris.Load.BMPfromeMatris2D(ref newImageMatris, width, height);
        }
        /// <summary>
        /// حذف نقاط ایزوله در تصویر باینری
        /// </summary>
        public static Bitmap Remove(ref Bitmap bmp)
        {
            int[,] imagemat = Matris.Load.Matris2DFromeBMP(ref bmp);

            int w = bmp.Width, h = bmp.Height;
            int[,] ans = new int[w, h];

            for (int i = 1; i < w - 1; i++)
            {
                for (int j = 1; j < h - 1; j++)
                {
                    if (imagemat[i, j] == 1)
                    {
                        bool hoodfound = false;
                        for (int a = -1; a < 2; a++)
                            for (int b = -1; b < 2; b++)
                                if (!(a == 0 && b == 0))
                                    if (imagemat[i + a, j + b] == 1)
                                        hoodfound = true;
                        if (hoodfound == false)
                            ans[i, j] = 0;
                        else
                            ans[i, j] = 1;
                    }
                }
            }

            return Matris.Load.BMPfromeMatris2D(ref ans, w, h);
        }

        public static Bitmap Endpoints(ref Bitmap image)
        {
            int[,] imagematris = Matris.Load.Matris2DFromeBMP(ref image);

            //creating LUT answers
            int[] endpointLUT = new int[512];
            for (int lutnumber = 0; lutnumber < 512; lutnumber++)
            {
                int[,] LUT = getLUTfromeNumber(lutnumber);
                endpointLUT[lutnumber] = IsEndPoint(LUT);
            }

            //traverse image and create new image
            int width = image.Width, height = image.Height;
            int[,] newimage = new int[width, height];
            for (int i = 1; i < width-1; i++)
            {
                for (int j = 1; j < height-1; j++)
                {
                    int[] LUT = Matris.Load.NHOODS_2D(ref imagematris, 3, i, j);
                    int LUTnumber = LUT[0] * 16 + LUT[1] * 128 + LUT[2] * 64 + LUT[3] * 8 + LUT[4] + LUT[5] * 2 + LUT[6] * 4 +
                        LUT[7] * 32 + LUT[8] * 256;
                    newimage[i, j] = endpointLUT[LUTnumber];
                }
            }

            return Matris.Load.BMPfromeMatris2D(ref newimage, width, height);
        }
        private static int[,] getLUTfromeNumber(int lutnumber)
        {
            int[,] LUT = new int[3, 3];
            int tmp = lutnumber / 256;
            LUT[0, 0] = tmp;
            tmp = (lutnumber % 256) / 128;
            LUT[0, 1] = tmp;
            tmp = (lutnumber % 128) / 64;
            LUT[0, 2] = tmp;
            tmp = (lutnumber % 64) / 32;
            LUT[1, 0] = tmp;
            tmp = (lutnumber % 32) / 16;
            LUT[1, 1] = tmp;
            tmp = (lutnumber % 16) / 8;
            LUT[1, 2] = tmp;
            tmp = (lutnumber % 8) / 4;
            LUT[2, 0] = tmp;
            tmp = (lutnumber % 4) / 2;
            LUT[2, 1] = tmp;
            tmp = (lutnumber % 2);
            LUT[2, 2] = tmp;
            return LUT;
        }
        public static int IsEndPoint(int[,] LUT)
        {
            if (
                Structurematches(LUT, new int[,] { { 0, 0, 0 }, { 0, 1, 1 }, { 0, 0, 0 } }) ||
                Structurematches(LUT, new int[,] { { 0, 0, 0 }, { 1, 1, 0 }, { 0, 0, 0 } }) ||
                Structurematches(LUT, new int[,] { { 0, 1, 0 }, { 0, 1, 0 }, { 0, 0, 0 } }) ||
                Structurematches(LUT, new int[,] { { 0, 0, 0 }, { 0, 1, 0 }, { 0, 1, 0 } }) ||
                Structurematches(LUT, new int[,] { { 1, 0, 0 }, { 0, 1, 0 }, { 0, 0, 0 } }) ||
                Structurematches(LUT, new int[,] { { 0, 0, 1 }, { 0, 1, 0 }, { 0, 0, 0 } }) ||
                Structurematches(LUT, new int[,] { { 0, 0, 0 }, { 0, 1, 0 }, { 1, 0, 0 } }) ||
                Structurematches(LUT, new int[,] { { 0, 0, 0 }, { 0, 1, 0 }, { 0, 0, 1 } }) ||
                Structurematches(LUT, new int[,] { { 0, 0, 0 }, { 0, 1, 1 }, { 0, 0, 1 } }) ||
                Structurematches(LUT, new int[,] { { 1, 0, 0 }, { 1, 1, 0 }, { 0, 0, 0 } }) ||
                Structurematches(LUT, new int[,] { { 0, 1, 1 }, { 0, 1, 0 }, { 0, 0, 0 } }) ||
                Structurematches(LUT, new int[,] { { 0, 0, 0 }, { 0, 1, 0 }, { 1, 1, 0 } }) ||
                Structurematches(LUT, new int[,] { { 1, 1, 0 }, { 0, 1, 0 }, { 0, 0, 0 } }) ||
                Structurematches(LUT, new int[,] { { 0, 0, 1 }, { 0, 1, 1 }, { 0, 0, 0 } }) ||
                Structurematches(LUT, new int[,] { { 0, 0, 0 }, { 1, 1, 0 }, { 1, 0, 0 } }) ||
                Structurematches(LUT, new int[,] { { 0, 0, 0 }, { 0, 1, 0 }, { 0, 1, 1 } })
                )
                return 1;
            return 0;
        }
        private static bool Structurematches(int[,] nhoods, int[,] structure)
        {
            bool matches1 = true;
            for(int i=0;i<3;i++)
                for(int j=0;j<3;j++)
                    if (nhoods[i, j] != structure[i, j])
                    {
                        matches1 = false;
                        i = 3;
                        break;
                    }

            int[,] nhoods_ = Matris.Logic.NOT(ref nhoods, 3, 3);
            int[,] structure_ = Matris.Logic.NOT(ref structure, 3, 3);

            bool matches2 = true;
            for (int i = 0; i < 3; i++)
                for (int j = 0; j < 3; j++)
                    if (nhoods_[i, j] != structure_[i, j])
                    {
                        matches2 = false;
                        i = 3;
                        break;
                    }

            return matches1 && matches2;
        }

        
        public static Bitmap DistanceTransform(ref Bitmap image)
        {
            return null;
        }//distanceTransform
        public static Bitmap bwperim(ref Bitmap image)
        {
            int width = image.Width, height = image.Height;
            int[,] imagematris = Matris.Load.Matris2DFromeBMP(ref image);
            int[,] newimagematris = new int[width, height];
            newimagematris = bwperim(ref imagematris, width, height);
            return Matris.Load.BMPfromeMatris2D(ref newimagematris, width, height);
        }
        public static int[,] bwperim(ref int[,] imagematris, int width, int height)
        {
            int[,] newimagematris = new int[width, height];

            for (int i = 1; i < width - 1; i++)
                for (int j = 1; j < height - 1; j++)
                    if (imagematris[i, j] == 1)
                    {
                        int[] hoods = Matris.Load.NHOODS_2D(ref imagematris, 3, i, j);
                        bool isperim = false; for (int k = 0; k < 9; k++) if (hoods[k] == 0) isperim = true;
                        if (isperim) newimagematris[i, j] = 1;
                    }
            return newimagematris;
        }
        public static Bitmap fillHole(ref Bitmap image, int x, int y)
        {
            int width = image.Width, height = image.Height;

            if (x < 0 || x >= width || y < 0 || y >= height) throw new Exception("ERRORE : bad position!");

            int[,] imagematris = Matris.Load.Matris2DFromeBMP(ref image);
            Matris.Logic.NOT_(ref imagematris, width, height);
            int[,] newimagematris = new int[width, height];
            int[,] newimagematris2 = new int[width, height];

            int[,] mask = new int[,] { { 0, 1, 0 }, { 1, 1, 1 }, { 0, 1, 0 } };
            for (int i = 0; i < width; i++) for (int j = 0; j < height; j++) newimagematris[i, j] = 0;
            newimagematris[x, y] = 1;
            while (true)
            {
                morph(ref newimagematris, ref newimagematris2, width, height, "inc", ref mask, 3, 3);
                //Matris.Save.Matris2DToBMPFile(ref newimagematris2, width, height, "tmp.bmp");
                Matris.Logic.AND(ref newimagematris2, ref imagematris, ref newimagematris2, width, height);
                //Matris.Save.Matris2DToBMPFile(ref newimagematris, width, height, "tmp.bmp");
                if (Matris.Logic.AreEqual(ref newimagematris, ref newimagematris2, width, height)) break;
                Matris.Edit.copy(ref newimagematris, ref newimagematris2, width, height);
                //Matris.Save.Matris2DToBMPFile(ref newimagematris, width, height, "tmp.bmp");
            }

            Matris.Logic.NOT_(ref imagematris, width, height);
            Matris.Logic.OR(ref newimagematris, ref imagematris, ref newimagematris, width, height);

            return Matris.Load.BMPfromeMatris2D(ref newimagematris, width, height);
        }
        public static int[,] fillhole(ref int[,] imagematris, int width, int height, int x, int y)
        {
            if (x < 0 || x >= width || y < 0 || y >= height) throw new Exception("ERRORE : bad position!");

            Matris.Logic.NOT_(ref imagematris, width, height);
            int[,] newimagematris = new int[width, height];
            int[,] newimagematris2 = new int[width, height];

            int[,] mask = new int[,] { { 0, 1, 0 }, { 1, 1, 1 }, { 0, 1, 0 } };
            for (int i = 0; i < width; i++) for (int j = 0; j < height; j++) newimagematris[i, j] = 0;
            newimagematris[x, y] = 1;
            while (true)
            {
                morph(ref newimagematris, ref newimagematris2, width, height, "inc", ref mask, 3, 3);
                Matris.Logic.AND(ref newimagematris2, ref imagematris, ref newimagematris2, width, height);
                if (Matris.Logic.AreEqual(ref newimagematris, ref newimagematris2, width, height)) break;
                Matris.Edit.copy(ref newimagematris, ref newimagematris2, width, height);
            }

            Matris.Logic.NOT_(ref imagematris, width, height);
            Matris.Logic.OR(ref newimagematris, ref imagematris, ref newimagematris, width, height);

            return newimagematris;
        }

        public static Bitmap ConvexRind(ref Bitmap image)
        {
            image = Filters.binary(ref image);
            int[,] binaryimage = Matris.Load.Matris2DFromeBMP(ref image);
            binaryimage = ConvexRind(ref binaryimage, image.Width, image.Height);
            return Matris.Load.BMPfromeMatris2D(ref binaryimage, image.Width, image.Height);
        }
        public static int[,] ConvexRind(ref int[,] imagematris, int width, int height)
        {
            //creating bigest convex-rind
            int[,] pattern1 = new int[,] { { 1, 1, 1 }, { 2, 0, 2 }, { 2, 2, 2 } };
            int[,] pattern2 = new int[,] { { 1, 2, 2 }, { 1, 0, 2 }, { 1, 2, 2 } };
            int[,] pattern3 = new int[,] { { 2, 2, 2 }, { 2, 0, 2 }, { 1, 1, 1 } };
            int[,] pattern4 = new int[,] { { 2, 2, 1 }, { 2, 0, 1 }, { 2, 2, 1 } };


            int[,] d1 = new int[width, height];
            int[,] d1_tmp = new int[width, height];
            Matris.Edit.copy(ref d1, ref imagematris, width, height);
            Matris.Edit.copy(ref d1_tmp, ref imagematris, width, height);
            while (true)
            {
                d1 = ERODE(ref d1, width, height, pattern1, 3, 3);
                Matris.Logic.OR(ref d1_tmp, ref d1, ref d1, width, height);
                //Matris.Save.Matris2DToBMPFile(ref d1, width, height, "tmp.bmp");
                if (Matris.Logic.AreEqual(ref d1, ref d1_tmp, width, height)) break;
                Matris.Edit.copy(ref d1_tmp, ref d1, width, height);
            }

            int[,] d2 = new int[width, height];
            int[,] d2_tmp = new int[width, height];
            Matris.Edit.copy(ref d2, ref imagematris, width, height);
            Matris.Edit.copy(ref d2_tmp, ref imagematris, width, height);
            while (true)
            {
                d2 = ERODE(ref d2, width, height, pattern2, 3, 3);
                Matris.Logic.OR(ref d2_tmp, ref d2, ref d2, width, height);
                if (Matris.Logic.AreEqual(ref d2, ref d2_tmp, width, height)) break;
                Matris.Edit.copy(ref d2_tmp, ref d2, width, height);
            }

            int[,] d3 = new int[width, height];
            int[,] d3_tmp = new int[width, height];
            Matris.Edit.copy(ref d3, ref imagematris, width, height);
            Matris.Edit.copy(ref d3_tmp, ref imagematris, width, height);
            while (true)
            {
                d3 = ERODE(ref d3, width, height, pattern3, 3, 3);
                Matris.Logic.OR(ref d3_tmp, ref d3, ref d3, width, height);
                if (Matris.Logic.AreEqual(ref d3, ref d3_tmp, width, height)) break;
                Matris.Edit.copy(ref d3_tmp, ref d3, width, height);
            }

            int[,] d4 = new int[width, height];
            int[,] d4_tmp = new int[width, height];
            Matris.Edit.copy(ref d4, ref imagematris, width, height);
            Matris.Edit.copy(ref d4_tmp, ref imagematris, width, height);
            while (true)
            {
                d4 = ERODE(ref d4, width, height, pattern4, 3, 3);
                Matris.Logic.OR(ref d4_tmp, ref d4, ref d4, width, height);
                if (Matris.Logic.AreEqual(ref d4, ref d4_tmp, width, height)) break;
                Matris.Edit.copy(ref d4_tmp, ref d4, width, height);
            }

            int[,]CA=new int[width,height];
            Matris.Logic.OR(ref d1, ref d2, ref CA, width, height);
            Matris.Logic.OR(ref CA, ref d3, ref CA, width, height);
            Matris.Logic.OR(ref CA, ref d4, ref CA, width, height);

            //reduce convex
            int[,] FilledFrame = Matris.Create.FillFrameOfComponent(ref imagematris, width, height);
            Matris.Logic.AND(ref CA, ref FilledFrame, ref CA, width, height);

            //extract convex's rind
            CA = bwperim(ref CA, width, height);

            //adding to original image
            Matris.Logic.OR(ref CA, ref imagematris, ref CA, width, height);

            return CA;
        }

        public static Bitmap ShowMaxEmptyAreaOnCenter(ref Bitmap image)
        {
            int[,] imagematris = Matris.Load.Matris2DFromeBMP(ref image);
            int w = image.Width, h = image.Height;

            int minW = 0;
            for (int i = w / 2; i > 0; i--) if (imagematris[i, h / 2] == 1) { minW = i; break; }
            int maxW = w;
            for (int i = w / 2; i < w; i++) if (imagematris[i, h / 2] == 1) { maxW = i; break; }
            int minH = 0;
            for (int j = h / 2; j > 0; j--) if (imagematris[w / 2, j] == 1) { minH = j; break; }
            int maxH = h;
            for (int j = h / 2; j < h; j++) if (imagematris[w / 2, j] == 1) { maxH = j; break; }

            Bitmap newimage = new Bitmap(image);
            for (int i = minW; i < maxW; i++)
            {
                newimage.SetPixel(i, minH, Color.Red);
                newimage.SetPixel(i, maxH, Color.Red);
            }
            for (int j = minH; j < maxH; j++)
            {
                newimage.SetPixel(minW, j, Color.Red);
                newimage.SetPixel(maxW, j, Color.Red);
            }

            return newimage;
        }
        #endregion

        public static Color[] colors = new Color[] { Color.Yellow,Color.Orange,Color.LightGray,Color.Pink,Color.Violet,Color.LightBlue,
        Color.DarkBlue,Color.LightGreen,Color.DarkGreen,Color.Brown,Color.Chocolate,Color.Red,Color.DarkGray,Color.Aqua,
        Color.Magenta,Color.LightSeaGreen,Color.GreenYellow,Color.BurlyWood,Color.Firebrick,Color.LemonChiffon,Color.SandyBrown};

    }//morphology class

}
